require "selenium-webdriver"
require "rspec"
require "./spec/spec_helper"
require_relative "../../pages/_config"
require "./pages/provider_login"
require "./pages/search"
include RSpec::Expectations


describe "Patient Search: PV-1439" do

  before(:all) do
    @driver = Selenium::WebDriver.for :firefox
    @base_url = $acp_url
    @wrapper_url = $acp_url + "/" + $acp_app
    @accept_next_alert = true
    @wait = Selenium::WebDriver::Wait.new(:timeout => 10)
    @driver.manage.timeouts.implicit_wait = 10
    @verification_errors = []

    @login = ProviderLogin.new @driver
    @login.loginAsCprs1234()
            
    @driver.get(@wrapper_url)
    @search = Search.new(@driver)
  end
  
  after(:all) do
    @driver.quit
    @verification_errors.should == []
  end
  
  before(:each) do
    @driver.get(@wrapper_url)
  end  
  
  describe "Patient Search by Clinic: PV-115" do
    
    it 'should display the heading of Clinic Search: PV-115' do
      @search.openSearchMenu()
      @search.selectClinicSearch()
      @wait.until{ @driver.find_element(:css, '.ui-title').text !='' }
      expect(@search.getSearchHeader()).to eq('Clinic Search')
     end
 
     it 'should display an alphabetically-sorted list of clinics: PV-112' do
       @search.searchByClinic("dia")
       clinicList = @search.getClinicList()

       previousItem = clinicList[0].text()
       for i in (0...clinicList.size)
         nextItem = clinicList[i].text()
         expect(previousItem <= nextItem).to be_true
         previousItem = nextItem
       end

     end
 
     it 'should allow filtering of patients within a clinic: PV-273, PV-1734' do
       @search.openSearchMenu()
       @search.selectClinicSearch()
                                  #mmm,  dd,  yyyy
       @search.filterClinicByDate("DEC","17","2013")
       @driver.find_element(:css, "#primary-search-filter .ui-input-search input").clear
       @driver.find_element(:css, "#primary-search-filter .ui-input-search input").send_keys "COMP"
       sleep(2) # ToDo: replace with wait until
       @search.selectClinicAtRow(3)
       sleep(5) # ToDo: replace with wait until

       startingResultLength = @search.getSearchResultsLength()

       #Fails becuase patient list is not alpha sorted
       #Verify the patient list is sorted
       list = @search.getDisplayedList('#patient-list li h3')
       previousPatient = list[0].downcase#()
       for i in (0...list.size)
         nextPatient = list[i].downcase#()
         expect(previousPatient <= nextPatient).to be_true
         previousPatient = nextPatient
       end

       @search.filterSearchResults("eighteen")
       sleep(5) # ToDo: replace with wait until
       expect(startingResultLength).to be > @search.getSearchResultsLength()
     end

     it 'should persist search criteria: PV-381' do
       @search.searchByClinic("DIA")
       sleep(3) # ToDo: replace with wait until
       @search.selectClinicAtRow(7)

       #Navigate away from search and return
       @search.selectWardSearch()
       @search.selectClinicSearch()

       expect(@search.getSearchCriteria()).to eq("DIABETIC")
     end

     it 'should display the current date as the filter' do
       @search.searchByClinic("DIA")
       expect(@search.getClinicDateFilterValue()).to eq(Time.new().strftime("%m/%d/%Y"))
     end

  end #close clinic describe block  
  
  
  
end  